package lrs.test;

import junit.framework.TestCase;

import lrs.*;
import lrs.visitor.*;


public class Test_IsInLRS extends TestCase {

  IAlgo algo = IsInLRS.Singleton;
  
  public void test_empty_list() {
    LRStruct list1 = makeLRS();    
    assertEquals("", false, list1.execute(algo, "a"));
  }

  public void test_non_empty_list() {
    LRStruct list1 = makeLRS("a");    
    assertEquals("", true, list1.execute(algo, "a"));
    assertEquals("", false, list1.execute(algo, "b"));

    list1 = makeLRS("c", "a", "d");    
    assertEquals("", true, list1.execute(algo, "a"));
    assertEquals("", false, list1.execute(algo, "b"));

    list1 = makeLRS("a", "c", "a", "d");    
    assertEquals("", true, list1.execute(algo, "a"));
    assertEquals("", true, list1.execute(algo, "d"));
    assertEquals("", false, list1.execute(algo, "b"));
    
  }
  
  
  /**
   * instantiates and fills an LRS with the given values.
   */
  LRStruct makeLRS(Object...args) {
    return LRSFactory.makeFrom(args);
  }
  
}
