package brs;

import brs.BiTree;
import brs.visitor.*;

/**
* Driver to test the primitive structural behaviors of a BiTree and
* the vertical tree printing algorithm via the toString method.
* @author Dung X. Nguyen
*/
public class BiTreeClient {
    public void testTree() {
        BiTree t0 = new BiTree();
        t0.insertRoot(new Integer(15));
        System.out.println("t0's root = " + t0.getRootDat());
        System.out.println("t0.remRoot() returns " + t0.remRoot ());

        BiTree t1 = new BiTree();
        t1.insertRoot(new Integer(55));
        BiTree t2 = new BiTree();
        t2.insertRoot(new Integer(79));
        t1.setLeftSubTree(t0);
        t1.setRightSubTree(t2);
        t0.insertRoot(new Integer(62));
        t0.getLeftSubTree().insertRoot(new Integer(20));
        t0.getRightSubTree().insertRoot(new Integer(7));
        t2.getLeftSubTree().insertRoot(new Integer(200));
        t2.getRightSubTree().insertRoot(new Integer(100));
        t0.getLeftSubTree().getRightSubTree().insertRoot(new Integer(18));
        t0.getLeftSubTree().getRightSubTree().getLeftSubTree().
                                                   insertRoot(new Integer(39));
        t2.getLeftSubTree().getRightSubTree().insertRoot(new Integer(30));
        t2.getLeftSubTree().getRightSubTree().getLeftSubTree().
                                                  insertRoot(new Integer(-17));
        System.out.println("t0 is: \n" + t0 + "\n");
        System.out.println("t2 is: \n" + t2 + "\n");
        System.out.println("t1 is: \n" + t1 + "\n");

        try {
            t1.remRoot ();  // should throw exception here!
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * @param args == null - not used.
     */
    public static void main(String[] args) {
        new BiTreeClient().testTree();
    }
}

