package brs.visitor;

import brs.*;

public class RotateLeft implements IVisitor {
    
    public static final RotateLeft Singleton = new RotateLeft();
    private RotateLeft() {}
    
    public Object emptyCase(BiTree parent, Object nu) {
        return parent;
    }
    public Object nonEmptyCase(final BiTree parent, Object nu) {
        return parent.getRightSubTree().execute(new IVisitor () { 
            
            public Object emptyCase(BiTree right, Object nu) {
                return parent;
            }
            
            public Object nonEmptyCase(BiTree right, Object nu) {
                BiTree newLeft = new BiTree();
                newLeft.insertRoot(parent.getRootDat());
                newLeft.setLeftSubTree(parent.getLeftSubTree());
                newLeft.setRightSubTree(right.getLeftSubTree());
                parent.setRootDat(right.getRootDat());
                parent.setRightSubTree(right.getRightSubTree());
                parent.setLeftSubTree(newLeft);
                return parent;
            }
        }, null);
    }
    
}

