package treap;

import brs.visitor.*;
import brs.*;
import java.util.*;

/**
 * Pushes the top element of a treap, if any, down to the bottom and remove it,
 * while maintaining the treap property.
 * The student is to complete the code for the helper visitors: 
 * _pushDownHelp2 and _pushDownHelp1
 * as specified below.
 */
public class PushDown implements IVisitor {
    private Comparator<TreapTriple> _orderPriority; 
    /**
     * _pushDoenHelp1 is called by the left subtree of the tree that 
     * calls the master visitor PushDown.
     * Both emptyCase and nonEmptyCase have the following parameters
     * and return type.
     * @param left the left subtree of p.
     * @param parent the parent of left.
     * @return Boolean TRUE
     */
    private IVisitor _pushDownHelp1 = new IVisitor() {
        /**
         * If the host, which is the left subtree of the parent p, is empty,
         * then the parent node can be safely removed, so remove it.
         */
        public Object emptyCase (BiTree left, Object parent) {
            // STUDENT TO COMPLETE
            return null;
        }
        
        /**
         * This is the case where we know the left subtree is not empty, but
         * we do not know what the right subtree is.  So delegate the task
         * of pushing down and remove the parent node to the right subtree,
         * passing to it its parent.
         * NOTE: Since _pushDownHelp2 has already been defined, it may
         * be referenced here.
         */
        public Object nonEmptyCase (BiTree left, Object parent) {
            // STUDENT TO COMPLETE
            return null;                        
        }
    };           
    
    /**
     * _pushDownHelp2 is called by the right subtree of the tree that calls 
     * PushDown to pushdown and remove the parent node.
     * Both emptyCase and nonEmptyCase have the following parameters
     * and return type.
     * @param right the right subtree of p.
     * @param parent the parent of right.
     * @return Boolean TRUE
     */
    private IVisitor _pushDownHelp2  = new IVisitor() {
        /**
         * If the host, which is the right subtree of the parent p, is empty,
         * then the parent node can be safely removed, so remove it.
         */
        public Object emptyCase (BiTree right, Object parent) {
            // STUDENT TO COMPLETE
            return null;
        }
        
        /**
         * This is the case where the parent tree has two non-empty subtrees.
         * Compare the priorities of the left and right subtrees and perform
         * the appropriate (left/right) rotation to move the parent node down
         * one level; then call on the master pushDown visitor to recursively
         * push down the subtree that now holds the parent node.
         */
        public Object nonEmptyCase (BiTree right, Object parent) {
            // First save a bunch of type-casts:
            BiTree p = (BiTree)parent;
            TreapTriple rightRoot = (TreapTriple)right.getRootDat();
            TreapTriple leftRoot = (TreapTriple)p.getLeftSubTree().getRootDat();
            // STUDENT TO COMPLETE
            return null;
        }
    }; 
    
    
    public PushDown() {
        _orderPriority = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getPriorityComparable().compareTo(y);
            }
        };
    }
    
    public PushDown (Comparator<TreapTriple> orderPriority) {
        _orderPriority = orderPriority;
    }
    
    /**
     * There is nothing to do.
     */
    public Object emptyCase(BiTree host, Object nu) {
        return Boolean.TRUE;
    }
    
    /**
     * The host's subtrees should know whether to remove the host or to keep
     * pushing it down by an appropriate(left/right) rotation.  So, delegate
     * to the left subtree, asking for help and passing to it the parent tree,
     * which is the host.
     */
    public Object nonEmptyCase(BiTree host, Object key) {
        return host.getLeftSubTree().execute(_pushDownHelp1, host);                                                          
    }
}

