package treap;

import brs.visitor.*;
import brs.*;
import java.util.*;

/**
 * Inserts an TreapTriple into the host maintaining the host's treap
 * property.
 * Duplication is not allowed: replaces old data object with the new one.
 */
public class TreapDeleter implements IVisitor {
    private Comparator<TreapTriple> _orderKey;
    private Comparator<TreapTriple> _orderPriority;    
    private IVisitor _pushDown = NoOpVisitor.Singleton;
    
    public TreapDeleter() {
        _orderKey = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getKeyComparable().compareTo(y);
            }
        };
        _orderPriority = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getPriorityComparable().compareTo(y);
            }
        };
        _pushDown = new PushDown();
    }
    
    public TreapDeleter (Comparator<TreapTriple> orderKey, 
                         Comparator<TreapTriple> orderPriority) {
        _orderKey = orderKey;
        _orderPriority = orderPriority;
        _pushDown = new PushDown(_orderPriority);
    }
    
    /**
     * There is nothing to delete.
     */
    public Object emptyCase(BiTree host, Object nu) {
        return Boolean.FALSE;
    }
    
    /**
     * @param host a non-empty Treap.
     * @param key a TreapTriple to be remove from host.
     */
    public Object nonEmptyCase(BiTree host, Object key) {
        // STUDENT TO COMPLETE
        return null;
    }
}

