package treap;

import brs.visitor.*;
import brs.*;
import java.util.*;
import fp.*;

/**
 * Inserts an Object into the host maintaining the host's treap property.
 * Duplication is not allowed: replaces old data object with the new one.
 */
public class TreapInserter implements IVisitor {
    private Comparator<TreapTriple> _orderKey;
    private Comparator<TreapTriple> _orderPriority;
    private IVisitor _remove;
    
    /**
     * Helper visitor to insert a TreapTriple into a treap that does not contain this
     * TreapTriple object.
     */
    private IVisitor _insertHelp = new IVisitor() {
        /**
         * Returns the host tree where the input is inserted as the root.
         * @param host an empty binary tree, which obviously satisfies the Treap property.
         * @param input new data to be inserted.
         * @return BiTree host, which is no longer empty.
         */
        public Object emptyCase(BiTree host, Object input) {
            // STUDENT TO COMPLETE
            return null;
        }
        
        /**
         * Inserts the input TreapTriple object, assuming the input is NOT in 
         * the host tree.
         * @param host non-empty, not containing the input to be inserted and 
         * satisfies Treap property.
         * @param input new data to be inserted.
         * @return BiTree the host tree.
         */
        public Object nonEmptyCase(BiTree host, Object input) {
            // First, save a bunch of type-casts.
            TreapTriple inp = (TreapTriple) input;        
            TreapTriple root = (TreapTriple) host.getRootDat();
            // STUDENT TO COMPLETE
            return null;
        }    
    };
       
    /**
     * Used when the items in the tree are Comparable objects.
     */
    public TreapInserter() {
        _orderKey = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getKeyComparable().compareTo(y);
            }
        };
        _orderPriority = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getPriorityComparable().compareTo(y);
            }
        };
        _remove = new TreapDeleter();
    }
    
    public  TreapInserter (Comparator<TreapTriple> orderKey,
                            Comparator<TreapTriple> orderPriority) {
        _orderKey = orderKey;
        _orderPriority = orderPriority;
        _remove = new TreapDeleter(_orderKey, _orderPriority);
    }
    
    /**
     * Returns the host tree where the input is inserted as the root.
     * @param host an empty binary tree, which obviously satisfies 
     * the Treap propertu.
     * @param input new data to be inserted.
     * @return BiTree host, which is no longer empty.
     */
    public Object emptyCase(BiTree host, Object input) {
        // STUDENT TO COMPLETE
        return null;
    }
    
    /**
     * If the input is equal to host.getRootDat) then the old root data is
     * removed and replaced by input.
     * @param host non-empty and satisfies the Treap property.
     * @param input new data to be inserted.
     * @return BiTree the host tree.
     */
    public Object nonEmptyCase(BiTree host, Object input) {
        // STUDENT TO COMPLETE
        return null;
    }
}

