package treap;

import java.util.*;

/**
 * Data object to be inserted into a Treap.
 */
public class TreapTriple implements ITreapTriple {
    private Object _value;
    
    private int _key;
    
    private int _priority;
    
    private Comparable<TreapTriple> _keyComp = new Comparable<TreapTriple>() {
        public int compareTo(TreapTriple other) {
            return _key - other._key;
        }
    };
    
    private Comparable<TreapTriple> _priorityComp = new Comparable<TreapTriple>() {
        public int compareTo(TreapTriple other) {
            return _priority - other._priority;
        }
    };
    
    public TreapTriple(Object value, int key, int priority) {
        _value = value;
        _key = key;
        _priority = priority;
    }
    
    public Object getValue() {
        return _value;
    }
    
    public Comparable<TreapTriple> getKeyComparable() {
        return _keyComp;
    }
    
    public Comparable<TreapTriple> getPriorityComparable() {
        return _priorityComp;
    }
    
    public String toString() {
        return "("+_value+", "+_key+", "+_priority+")";
    }
}