package treap.test;
import treap.*;
import brs.*;
import brs.visitor.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_PushDown extends TestCase {
    
    IVisitor insert_SOL = new TreapInserter_SOL();
    IVisitor pushDown_SOL = new PushDown_SOL();
    IVisitor pushDown = new PushDown() ; // Student's code.
    BiTree bt_SOL = new BiTree();
    BiTree bt = new BiTree();
    
    private void pushDownTreap(String s, BiTree bt, IVisitor v) {
        bt.execute(v, null);
        System.out.println(s + "\n" + bt + '\n');
    }
    
    private void doInsert(TreapTriple...args) {
        System.out.print("Insert ");
        for (TreapTriple d: args) {
            System.out.print(d + " ");
        }
        for(TreapTriple d: args) {
            bt_SOL.execute(insert_SOL, d);
            bt.execute(insert_SOL, d);
        }
        System.out.println(":\n" + bt_SOL + '\n');
    }
    
    private void clearTrees() {
        bt_SOL = new BiTree();
        bt = new BiTree();
    }

    public void test_PushDown() {
        System.out.println("Empty treap:\n" + bt_SOL + '\n');
        pushDownTreap("Empty push down ", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
        
        TreapTriple a = new TreapTriple("A", 50, 100);
        doInsert(a);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
        
        TreapTriple b = new TreapTriple("B", 25, 200);
        clearTrees();
        doInsert(a, b);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
        
        TreapTriple c = new TreapTriple("C", 10, 300);
        clearTrees();
        doInsert(a, b, c);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
        
        TreapTriple d = new TreapTriple("D", 75, 150);
        clearTrees();
        doInsert(a, b, c, d);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        
        TreapTriple e = new TreapTriple("E", 65, 75);
        clearTrees();
        doInsert(a, b, c, d, e);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
        
        TreapTriple f = new TreapTriple("F", 35, 45);
        clearTrees();
        doInsert(a, b, c, d, e, f);
        pushDownTreap("Push down SOL", bt_SOL, pushDown_SOL);
        pushDownTreap("Push down", bt, pushDown);
        assertEquals("Push Down:", bt_SOL.toString(), bt.toString());
    }
    
    public static void main(String [] args){
        (new Test_PushDown()).test_PushDown();
    }
}
