package treap.test;
import treap.*;
import brs.*;
import brs.visitor.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_TreapDeleter extends TestCase {
    BiTree bt_SOL = new BiTree();
    BiTree bt = new BiTree();
            
    private void doVisitor(String s, BiTree bt, IVisitor v, TreapTriple...args) {
        for(TreapTriple d: args) {
            bt.execute(v, d);
        }
        System.out.print(s);
        for (TreapTriple d: args) {
            System.out.print(d + " ");
        }
        System.out.println(":\n" + bt + '\n');
    }
    
    private void clearTrees() {
        bt_SOL = new BiTree();
        bt = new BiTree();
    }

    public void test_delete() {
        IVisitor insert_SOL = new TreapInserter_SOL();
        IVisitor remove_SOL = new TreapDeleter_SOL();
        IVisitor remove = new TreapDeleter();  // Student's visitor
        
        TreapTriple a = new TreapTriple("A", 50, 100);
        TreapTriple b = new TreapTriple("B", 25, 200);
        TreapTriple b2 = new TreapTriple("B2", 35, 240);
        TreapTriple c = new TreapTriple("C", 10, 300);
        TreapTriple d = new TreapTriple("D", 75, 150);
        TreapTriple d2 = new TreapTriple("D2", 85, 250);
        TreapTriple d3 = new TreapTriple("D3", 70, 350);
        TreapTriple e = new TreapTriple("E", 65, 75);
        TreapTriple f = new TreapTriple("F", 35, 45);
        TreapTriple e2 = new TreapTriple("E2", 65, 25);
        TreapTriple e3 = new TreapTriple("E3", 65, 111);

        /// Begin CORE tests:
        System.out.println("Treap:\n" + bt_SOL + '\n');
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        
        doVisitor("Insert ", bt_SOL, insert_SOL, a);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, b);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b);
        doVisitor("Remove ", bt_SOL, remove_SOL, b);
        doVisitor("Insert ", bt, insert_SOL, a, b);
        doVisitor("Remove ", bt, remove, b);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, d);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d);
        doVisitor("Remove ", bt_SOL, remove_SOL, d);
        doVisitor("Insert ", bt, insert_SOL, a, d);
        doVisitor("Remove ", bt, remove, d);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, d);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, b, d);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, d);
        doVisitor("Remove ", bt_SOL, remove_SOL, b);
        doVisitor("Insert ", bt, insert_SOL, a, b, d);
        doVisitor("Remove ", bt, remove, b);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, d);
        doVisitor("Remove ", bt_SOL, remove_SOL, d);
        doVisitor("Insert ", bt, insert_SOL, a, b, d);
        doVisitor("Remove ", bt, remove, d);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        /// End of CORE tests

        ///// Extras
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, c);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, b, c);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, c);
        doVisitor("Remove ", bt_SOL, remove_SOL, b);
        doVisitor("Insert ", bt, insert_SOL, a, b, c);
        doVisitor("Remove ", bt, remove, b);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, c);
        doVisitor("Remove ", bt_SOL, remove_SOL, c);
        doVisitor("Insert ", bt, insert_SOL, a, b, c);
        doVisitor("Remove ", bt, remove, c);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt_SOL, remove_SOL, b);
        doVisitor("Insert ", bt, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt, remove, b);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt_SOL, remove_SOL, b2);
        doVisitor("Insert ", bt, insert_SOL, a, b, b2);
        doVisitor("Remove ", bt, remove, b2);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt_SOL, remove_SOL, d);
        doVisitor("Insert ", bt, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt, remove, d);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt_SOL, remove_SOL, d2);
        doVisitor("Insert ", bt, insert_SOL, a, d, d2);
        doVisitor("Remove ", bt, remove, d2);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt_SOL, remove_SOL, a);
        doVisitor("Insert ", bt, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt, remove, a);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt_SOL, remove_SOL, d);
        doVisitor("Insert ", bt, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt, remove, d);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt_SOL, remove_SOL, d3);        
        doVisitor("Insert ", bt, insert_SOL, a, d, d3);
        doVisitor("Remove ", bt, remove, d3);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
                
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, f, a, b, c, d, e, a);
        doVisitor("Remove ", bt_SOL, remove_SOL, c);
        doVisitor("Insert ", bt, insert_SOL, f, a, b, c, d, e, a);
        doVisitor("Remove ", bt, remove, c);
        assertEquals("Delete:", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        // replaces "E" with same key but lower priority
        doVisitor("Insert ", bt_SOL, insert_SOL, e, a, b, c, d, f, e2);
        doVisitor("Remove ", bt_SOL, remove_SOL, b);
        doVisitor("Insert ", bt, insert_SOL, e, a, b, c, d, f, e2);
        doVisitor("Remove ", bt, remove, b);
        assertEquals("Delete: " + b, bt_SOL.toString(), bt.toString());
        
        clearTrees();
        // replaces "E" with same key but higher priority
        doVisitor("Insert ", bt_SOL, insert_SOL, e, a, f, b, c, d, e3, b2, d3);
        doVisitor("Remove ", bt_SOL, remove_SOL, e3);
        doVisitor("Insert ", bt, insert_SOL, e, a, f, b, c, d, e3, b2, d3);
        doVisitor("Remove ", bt, remove, e3);
        assertEquals("Delete: " + e3, bt_SOL.toString(), bt.toString());
    }
}
