package treap.test;
import treap.*;
import brs.*;
import brs.visitor.*;

import junit.framework.TestCase;

/**
 */
public class Test_TreapInserter extends TestCase {
    BiTree bt_SOL = new BiTree();
    BiTree bt = new BiTree();
    
    private void doVisitor(String s, BiTree bt, IVisitor v, TreapTriple...args) {
        for(TreapTriple d: args) {
            bt.execute(v, d);
        }
        System.out.print(s);
        for (TreapTriple d: args) {
            System.out.print(d + " ");
        }
        System.out.println(":\n" + bt + '\n');
    }
    
    private void clearTrees() {
        bt_SOL = new BiTree();
        bt = new BiTree();
    }

    public void test_insert() {
        IVisitor insert_SOL = new TreapInserter_SOL();
        IVisitor insert = new TreapInserter(); // Student's visitor
        
        TreapTriple a = new TreapTriple("A", 50, 100);
        TreapTriple b = new TreapTriple("B", 25, 200);
        TreapTriple b2 = new TreapTriple("B2", 35, 240);
        TreapTriple c = new TreapTriple("C", 10, 300);
        TreapTriple d = new TreapTriple("D", 75, 150);
        TreapTriple d2 = new TreapTriple("D2", 85, 250);
        TreapTriple d3 = new TreapTriple("D3", 70, 350);
        TreapTriple e = new TreapTriple("E", 65, 75);
        TreapTriple f = new TreapTriple("F", 35, 45);
        TreapTriple e2 = new TreapTriple("E2", 65, 25);
        TreapTriple e3 = new TreapTriple("E3", 65, 111);

        /// Begin CORE tests:
        System.out.println("Treap:\n" + bt + '\n');        
        doVisitor("Insert ", bt_SOL, insert_SOL, a);
        doVisitor("Insert ", bt, insert, a);
        assertEquals("Insert: " + a, bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b);
        doVisitor("Insert ", bt, insert, a, b);
        assertEquals("Insert: " + a + " " + b, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, b, a);
        doVisitor("Insert ", bt, insert, b, a);
        assertEquals("Insert: " + b + " " + a, bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d);
        doVisitor("Insert ", bt, insert, a, d);
        assertEquals("Insert: " + a + " " + d, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt_SOL, insert_SOL, d, a);
        doVisitor("Insert ", bt, insert, d, a);
        assertEquals("Insert: " + d + " " + a, bt_SOL.toString(), bt.toString());

        clearTrees();
        doVisitor("Insert ", bt, insert, a, b, d);        
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, d);
        assertEquals("Insert: " + a + " " + b + " " + d, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, b);
        doVisitor("Insert ", bt_SOL, insert_SOL, a, d, b);
        assertEquals("Insert: " + a + " " + d + " " + b, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, b, a, d);
        doVisitor("Insert ", bt_SOL, insert_SOL, b, a, d);
        assertEquals("Insert: " + b + " " + a + " " + d, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, d, a, b);        
        doVisitor("Insert ", bt_SOL, insert_SOL, d, a, b);
        assertEquals("Insert: " + d + " " + a + " " + b, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, b, d, a);
        doVisitor("Insert ", bt_SOL, insert_SOL, b, d, a);
        assertEquals("Insert: " + b + " " + d + " " + a, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, d, b, a);
        doVisitor("Insert ", bt_SOL, insert_SOL, d, b, a);
        assertEquals("Insert: " + d + " " + b + " " + a, bt_SOL.toString(), bt.toString());
        
        clearTrees();
        doVisitor("Insert ", bt, insert, a, b, c);        
        doVisitor("Insert ", bt_SOL, insert_SOL, a, b, c);
        assertEquals("Insert: " + a + " " + b + " " + c, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, a, c, b);        
        doVisitor("Insert ", bt_SOL, insert_SOL, a, c, b);
        assertEquals("Insert: " + a + " " + c + " " + b, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, b, a, c);
        doVisitor("Insert ", bt_SOL, insert_SOL, b, a, c);
        assertEquals("Insert: " + b + " " + a + " " + c, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, c, a, b);        
        doVisitor("Insert ", bt_SOL, insert_SOL, c, a, b);
        assertEquals("Insert: " + c + " " + a + " " + b, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, b, c, a);        
        doVisitor("Insert ", bt_SOL, insert_SOL, b, c, a);
        assertEquals("Insert: " + b + " " + c + " " + a, bt_SOL.toString(), bt.toString());
        clearTrees();
        doVisitor("Insert ", bt, insert, c, b, a);
        doVisitor("Insert ", bt_SOL, insert_SOL, c, b, a);
        assertEquals("Insert: " + c + " " + b + " " + a, bt_SOL.toString(), bt.toString());
        /// End of CORE tests

        ///// Extras

/*
        clearTrees();
        doVisitor("Insert ", bt, insert, a, b, b2);
        
        clearTrees();
        doVisitor("Insert ", bt, insert, a, b, b2);
        
        clearTrees();
        doVisitor("Insert ", bt, insert, a, b, b2);

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d2);

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d2);

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d2);        

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d3);

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d3);

        clearTrees();
        doVisitor("Insert ", bt, insert, a, d, d3); 
*/
        
        clearTrees();
        doVisitor("Insert ", bt, insert, f, a, b, c, d, e, a);
        doVisitor("Insert ", bt_SOL, insert_SOL, f, a, b, c, d, e, a);
        assertEquals("Insert: ", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        // replaces "E" with same key but lower priority
        doVisitor("Insert ", bt, insert, e, a, b, c, d, f, e2);
        doVisitor("Insert ", bt_SOL, insert_SOL, e, a, b, c, d, f, e2);
        assertEquals("Insert: ", bt_SOL.toString(), bt.toString());
        
        clearTrees();
        // replaces "E" with same key but higher priority
        doVisitor("Insert ", bt, insert, e, a, f, b, c, d, e3, b2, d3);
        doVisitor("Insert ", bt_SOL, insert_SOL, e, a, f, b, c, d, e3, b2, d3);
        assertEquals("Insert: ", bt_SOL.toString(), bt.toString());
    }    
    
    public static void main(String [] args){
        (new Test_TreapInserter()).test_insert();
    }
}
