package farmer;
import lrs.*;
import lrs.visitor.*;
import fp.*;
import java.util.*;

/**
 * Represents a state of the farmer and his items.
 */
public class State implements Comparable{
  private LRStruct _hereSet;  // The set of items with the farmer
  private LRStruct _thereSet; // The set of items at the other location
  private int _farmerLoc;  // The farmer's location: +1 = farm, -1 = market
  
  public State(LRStruct hereSet, int farmerLoc, LRStruct thereSet) {
    _hereSet = hereSet;
    _farmerLoc = farmerLoc;
    _thereSet = thereSet;
  }
  
  /**
   * comparison method for Comparable
   * Two states are equal if they have the same elements,
   * but not necessarily in the same order, in both their
   * _hereSet and _thereSet, plus they have the same value
   * for _farmerLoc.
   * Uses SetEquals which uses IsSubsetOfLRS
   */
  public int compareTo(Object other) {
    if(other instanceof State) {
      State otherState = (State)other;
      if((Boolean)(_hereSet.execute(SetEqualsLRS.Singleton, otherState._hereSet))
           && (_farmerLoc == otherState._farmerLoc)
           && (Boolean)(_thereSet.execute(SetEqualsLRS.Singleton, otherState._thereSet))) {    
        return 0;
      }
      else return +1; // arbitrary non-zero result.
    }
    else return -1; // arbitrary non-zero-result.
  }
  
  /**
   * Returns a list of all the possible next states, where *at most* one
   * item has been moved from the _hereSet to the _thereSet.
   */
  public LRStruct makeAllNextStates() {
    
    LRStruct next = (LRStruct)
      _hereSet.execute(MapCopyLRS.Singleton,
                       new ILambda() {
                           public Object apply(final Object ... xs) {
                             return new State
                               (((LRStruct)_thereSet.execute(CopyLRS.Singleton, null)).insertFront(xs[0]),
                                -1*_farmerLoc,
                                (LRStruct)((LRStruct)_hereSet.execute(CopyLRS.Singleton, null)).execute(FilterLRS.Singleton,
                                                                                                        new ILambda() {
                                                                                                            public Object apply(Object...ys) {
                                                                                                              return !xs[0].equals(ys[0]);
                                                                                                            }
                             }));
                           }
    });
    next.insertFront(new State((LRStruct)_thereSet.execute(CopyLRS.Singleton, null), 
                               -1*_farmerLoc, 
                               (LRStruct)_hereSet.execute(CopyLRS.Singleton, null)));
    
    return next;
  }
  
  /**
   * Returns a list of all possible next States whose thereSets are 
   * all contained in the given list of valid sets of items.
   * @param allOKSets  an LRStruct of LRStructs of allowable combinations
   * of items.   The order of the items in the set is immaterial.
   */
  public LRStruct makeOkNextStates(final LRStruct allOKSets) {
    return (LRStruct) makeAllNextStates().execute(FilterLRS.Singleton, 
                                       new ILambda() {
      public Object apply(final Object...s) {
        return allOKSets.execute(IsInLRS.Singleton, new Comparable() {
          public int compareTo(Object aSet) {
            return (Boolean)((LRStruct) aSet).execute(SetEqualsLRS.Singleton,((State)s[0])._thereSet)
              ? 0 : +1;
          }
        });
      }
    });
  }
  

  public String toString() {
    return "["+_hereSet+", "+_farmerLoc+", "+_thereSet+"]";
  }
  
}