package farmer.test;

import farmer.*;
import graphs.*;
import graphs.visitor.*;
import graphs.rac.*;
import lrs.*;
import lrs.visitor.*;
import java.util.*;
import fp.*;

import junit.framework.TestCase;


public class Test_Farmer extends TestCase {
  
  LRStruct okSets = makeLRS(makeLRS(),
                            makeLRS("Fox", "Corn"),
                            makeLRS("Fox"),
                            makeLRS("Goose"),
                            makeLRS("Corn"));
  
  State startState = new State(makeLRS("Fox", "Corn", "Goose"), +1, makeLRS());
  
  State endState = new State(makeLRS("Fox", "Corn", "Goose"), -1, makeLRS());
  
  FarmerVertex start = new FarmerVertex(startState, endState, okSets);
  
  public void test_RACTravAlgo() {
    
    ILambda baseFn = new ILambda() {
      public Object apply(Object...args) { 
        return (new LRStruct()).insertFront(args[0].toString());
      }
    };
    ILambda seenFn = new ILambda() {
      public Object apply(Object...args) { 
        return ((LRStruct) args[1]).insertFront("*"+args[0].toString());
      }
    };
    ILambda inductFn = new ILambda() {
      public Object apply(Object...args) {
        return ((LRStruct) args[1]).insertFront(args[0].toString());
      }
    };
    
    IVertexAlgo travAlgo1 = new RACTravAlgo(new RACStack());
    IVertexAlgo travAlgo2 = new RACTravAlgo(new RACQueue());
    
    
    LRStruct result1 = (LRStruct) start.execute(travAlgo1, baseFn, inductFn, seenFn);
    System.out.println("Stack result = \n"+result1);

    LRStruct result2 = (LRStruct) start.execute(travAlgo2, baseFn, inductFn, seenFn);
    System.out.println("Queue result = \n"+result2);
    
  }
  
  public void test_DFTravAlgo() {
    
    ILambda baseFn = new ILambda() {
      public Object apply(Object...args) { 
        // path has just this one vertex on it.
        LRStruct path = (new LRStruct()).insertFront(args[0].toString());
        return (new LRStruct()).insertFront(path); // return list of paths
      }
    };
    ILambda seenFn = new ILambda() {
      public Object apply(Object...args) { 
        // no viable paths through here
        return new LRStruct();  // return empty list of paths.
      }
    };
      
    ILambda inductFn = new ILambda() {
      public Object apply(final Object...args) {
       // recursive result is a set of lists of paths
        Collection<Object> rr = (Collection<Object>) args[1];
        final LRStruct result = new LRStruct(); // a list of paths
        // iterate through all lists of paths
        for(Object listOfPaths: rr) {
          ((LRStruct) listOfPaths).execute(new IAlgo() {
            public Object emptyCase(LRStruct host, Object nu) {
              // ignore empty lists of paths.
              return null;
            }
            public Object nonEmptyCase(LRStruct host, Object nu) {
              // add this vertex onto every path.
              result.insertFront(((LRStruct) host.getFirst()).insertFront(args[0].toString()));
              return host.getRest().execute(this, nu); // recur thru rest of paths
            }
          }, null);
        }
        return result;
      }
    };
    
    IVertexAlgo travAlgo1 = new DFTravAlgo();
    
    
    LRStruct result1 = (LRStruct) start.execute(travAlgo1, baseFn, inductFn, seenFn);
    System.out.println("Depth-first result = \n"+result1);

  }
  
  /**
   * Utility method used for debugging
   */
  public void printVertex(FarmerVertex aVertex) {                                               
    System.out.println("vertex = "+aVertex);
    for(IVertex v: aVertex.getNhbrs()) {
      System.out.println("nhbr = "+v);
    }
  }
  /**
   * Utility method that instantiates and fills an LRS with the given values.
   */
  LRStruct makeLRS(Object...args) {
    return LRSFactory.makeFrom(args);
  }
  
  /**
   * Useful for debugging because it will show the stack trace when an
   * exception is thrown.
   */
  public static void main(String[] args) {
    (new Test_Farmer()).test_RACTravAlgo();
  }
}
