package farmer.test;

import farmer.*;
import lrs.*;
import lrs.visitor.*;

import junit.framework.TestCase;


public class Test_State extends TestCase {
  
  
  public void test_compareTo() {
    State s1a = new State( makeLRS("a", "b"), +1, makeLRS("c", "d", "e"));
    State s1b = new State( makeLRS("b", "a"), +1, makeLRS("c", "e", "d"));
    State s1c = new State( makeLRS("a", "b"), -1, makeLRS("c", "d", "e"));
    State s2a = new State( makeLRS("g", "a"), +1, makeLRS("c", "e", "d"));
    State s3a = new State( makeLRS("a", "b"), +1, makeLRS("e", "d"));
    State s4a = new State( makeLRS(), +1, makeLRS("e", "d"));
    State s4b = new State( makeLRS(), +1, makeLRS("d", "e"));
    State s4c = new State( makeLRS("a", "b"), +1, makeLRS());
    
    assertEquals("",0,s1a.compareTo(s1b));
    assertEquals("",0,s1a.compareTo(s1b));
    assertEquals("",0,s1b.compareTo(s1a));
    assertEquals("",+1,s1a.compareTo(s1c));
    assertEquals("",+1,s1a.compareTo(s2a));
    assertEquals("",+1,s2a.compareTo(s1a));
    assertEquals("",+1,s2a.compareTo(s3a));
    assertEquals("",+1,s1a.compareTo(s4a));
    assertEquals("",0,s4a.compareTo(s4b));
    assertEquals("",+1,s4a.compareTo(s4c));    
  }
  
  public void test_makeAllNextStates() {
    State s1 = new State(makeLRS(), +1, makeLRS());
    
    LRStruct set1 = makeLRS(new State(makeLRS(), -1, makeLRS()));
    
    
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeAllNextStates()));
    
    s1 = new State(makeLRS("a"), +1, makeLRS());
    
    set1 = makeLRS(
                   new State(makeLRS("a"), -1, makeLRS()), 
                   new State(makeLRS(), -1, makeLRS("a")));
    
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeAllNextStates()));
    
    s1 = new State(makeLRS("a", "b"), -1, makeLRS());
    
    set1 = makeLRS(new State(makeLRS(), +1, makeLRS("b", "a")),
                   new State(makeLRS("a"), +1, makeLRS("b")), 
                   new State(makeLRS("b"), +1, makeLRS("a")));
    
     
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeAllNextStates()));
    assertEquals("",0,s1.compareTo(new State(makeLRS("a", "b"), -1, makeLRS())));  // s1 unchanged

    s1 = new State(makeLRS("a", "b"), -1, makeLRS("c"));
    
    set1 = makeLRS(new State(makeLRS("c"), +1, makeLRS("b", "a")),
                   new State(makeLRS("c", "a"), +1, makeLRS("b")), 
                   new State(makeLRS("c", "b"), +1, makeLRS("a")));
    
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeAllNextStates()));
  }
  
  public void test_makeOkNextStates() {
    State s1 = new State(makeLRS(), +1, makeLRS());
    LRStruct okSets = makeLRS(); // no ok sets.
    LRStruct set1 = makeLRS(); // no next states should be ok

    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    
    set1 = makeLRS(new State(makeLRS(), -1, makeLRS()));    
    okSets = makeLRS(makeLRS()); // empty set is ok.
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
                      
    
    s1 = new State(makeLRS("a"), +1, makeLRS());
    set1 = makeLRS(new State(makeLRS("a"), -1, makeLRS()));
    okSets = makeLRS(makeLRS());    
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    
    okSets = makeLRS(makeLRS("a"));        
    set1 = makeLRS(new State(makeLRS(), -1, makeLRS("a")));
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    
    okSets = makeLRS(makeLRS(), makeLRS("a"));        
    set1 = makeLRS(new State(makeLRS("a"), -1, makeLRS()), 
                   new State(makeLRS(), -1, makeLRS("a")));
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    

    s1 = new State(makeLRS("a", "b"), -1, makeLRS("c"));
    okSets = makeLRS(); // no ok sets.
    set1 = makeLRS(); // no next states should be ok
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));

    okSets = makeLRS(makeLRS("a", "b", "c")); // unreachable ok set
    set1 = makeLRS(); // no next states should be ok
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));

    okSets = makeLRS(makeLRS("a"));
    set1 = makeLRS( new State(makeLRS("c", "b"), +1, makeLRS("a")));
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    
    okSets = makeLRS(makeLRS(), makeLRS("a"), makeLRS("b"), makeLRS("a", "b"));     
    set1 = makeLRS(new State(makeLRS("c"), +1, makeLRS("b", "a")),
                   new State(makeLRS("c", "a"), +1, makeLRS("b")), 
                   new State(makeLRS("c", "b"), +1, makeLRS("a")));
    assertEquals("",true,(Boolean)set1.execute(SetEqualsLRS.Singleton, s1.makeOkNextStates(okSets)));
    
  }  
  
  
  
  /**
   * instantiates and fills an LRS with the given values.
   */
  LRStruct makeLRS(Object...args) {
    return LRSFactory.makeFrom(args);
  }
  
  
  
}
