package graphs;
import java.util.*;

/**
 * Abstract factory for IVertex vertices of a graph.
 */
public interface IGraphFactory {
  /**
   * Creates a set of interconnected IVertexs given their individual data elements and
   * a map of the interconnections between the IVertexs.
   * @param data an array of the individual data elements
   * @edges a Map relating the index of the element in the data array to a set of other elements, given as an array of indices.
   * @return an array of IVertex objects, whose order corresponds to the order of the elements in data.
   */
  public IVertex[] makeGraph(Object[] data, Map<Integer, Integer[]> edges);
}