package graphs;

import java.util.*;

/**
 * Interface representing a vertex on a graph
 */
public interface IVertex {
  
  /**
   * Accessor for the data stored at this vertex
   */
  public Object getDat();
  
  /**
   * Accessor for the set of IVertex neighbors of this vertex.
   */
  public Set<IVertex> getNhbrs();
  
  /**
   * Accept method for a visitor to this vertex.
   * @param algo an IVertexAlgo visitor to execute
   * @param params a variable number of arbitrary input parameters for the visitor.
   * @param  the result of executing the visitor
   */
  public Object execute(IVertexAlgo algo, Object...params);
}