package graphs.visitor;
import graphs.*;

/**
 * An abstract IVertexAlgo that separates the no-neighbors (sink) case from the others.
 */
public abstract class AGraphAlgo implements IVertexAlgo {
  public Object caseAt(int nNhbrs, IVertex host, Object...fns){
    return ((0 == nNhbrs) 
              ? case0(host, fns) 
              : defaultCase(nNhbrs, host, fns));
  }
  
  /**
   * caseAt(0,...) delegates to this method
   */
  protected abstract Object case0(IVertex host, Object...fns);
  
  /**
   * caseAt(i>0, ...) delegates to this method
   */
  protected abstract Object defaultCase(int nNhbrs, IVertex host, Object...fns);
}