package graphs.visitor;
import graphs.*;
import java.util.*;

/**
 * toString algo for an IVertex
 * Does not handle loops yet
 */
public class ToStringAlgo extends AGraphAlgo {
  
  public static final ToStringAlgo Singleton = new ToStringAlgo();
  private ToStringAlgo(){}
  private Set<IVertex> seen = new HashSet<IVertex>();
  
  protected Object case0(IVertex host, Object...fns) {
    return host.getDat().toString();
  }
  protected Object defaultCase(int nNhbrs, IVertex host, Object...fns){
    String result = host.getDat().toString();
    
    seen.add(host);
    result += processNext(host, "");
    seen.remove(host);
    return result;
  }
  
  private IVertexAlgo helper = new AGraphAlgo() {
    
    protected Object case0(IVertex host, Object...prefixes) {
      if(seen.contains(host)) return "|_["+host.getDat().toString()+"]";
      else return "|_ "+host.getDat().toString();
    }
    
    protected Object defaultCase(int nNhbrs, IVertex host, Object...prefixes){
      String result = "|_ ";
      if(seen.contains(host)) {
        result += "["+host.getDat().toString()+"]";
      }
      else { 
        result += host.getDat().toString();
        
        seen.add(host);
        result += processNext(host, (String)prefixes[0]);
        seen.remove(host);
      }
      return result;
    }
  };
  
  private String processNext(IVertex host, String prefix) {
    String result = "";
      Iterator<IVertex> it = host.getNhbrs().iterator();
      String resultLast = "\n"+prefix+it.next().execute(helper, prefix+"   ");// we know we need this one.
      while(it.hasNext()) {
        result += "\n"+prefix+it.next().execute(helper, prefix+"|  ");
      }
      return result+resultLast;
  }
  
}