package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * Maps a given fp.ILambda predicate across the list.
 * Returns true if for every element x in the list, 
 * pred.apply(x)returns true.  Returns false otherwise.
 * Exhibits "short-circuit" behavior in that if pred.apply(x) 
 * every returns false, the processing of the list is 
 * immediately terminated and false is returned.
 * If the list is empty, true is returned.
 * The original list is unchanged.
 */
public class AndMapLRS implements IAlgo {
  
  public static final AndMapLRS Singleton = new AndMapLRS();
  
  private AndMapLRS() {}
  
  public Object emptyCase(LRStruct host, Object pred) {
    return true;
  }
  
  public Object nonEmptyCase(LRStruct host, Object pred) {
    if((Boolean)((ILambda)pred).apply(host.getFirst())) {
      return host.getRest().execute(this, pred);
    }
    else {
      return false;
    }
  }
}