package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * Returns true if the host list is a subset of the 
 * given (as the input parameter) list.  That is, 
 * returns true if every element of the host is a member
 * of the given list.  Returns false otherwise.
 */
public class IsSubsetOfLRS_SOL implements IAlgo {
  
  public static final IsSubsetOfLRS_SOL Singleton = new IsSubsetOfLRS_SOL();
  
  private IsSubsetOfLRS_SOL() {}
  
  public Object emptyCase(LRStruct host, Object aList) {
    return true;
  }
  
  public Object nonEmptyCase(LRStruct host, Object aList) {
    final LRStruct otherList = (LRStruct) aList;
    return host.execute(AndMapLRS.Singleton, new ILambda() {
      public Object apply(Object...args) {
        return otherList.execute(IsInLRS_SOL.Singleton, args[0]);
       }
    });
  }
}