package lrs.visitor;
import lrs.*;


/**
 * Returns true if the host and the given lists contain 
 * exactly the same elements,though not necessarily in the same order.
 * equals() is used to determine equality.
 * Returns false otherwise.
 */
public class SetEqualsLRS_SOL implements IAlgo {
    public static final SetEqualsLRS_SOL Singleton = new SetEqualsLRS_SOL();
    private SetEqualsLRS_SOL() {}
    
    public Object emptyCase(LRStruct host, Object other){
        return ((LRStruct)other).execute(IsSubsetOfLRS_SOL.Singleton, host);
    }
    
    public Object nonEmptyCase(final LRStruct host, Object other){
      LRStruct otherLRS = (LRStruct) other;
      return 
        (Boolean) host.execute(IsSubsetOfLRS_SOL.Singleton, otherLRS)
        && (Boolean)otherLRS.execute(IsSubsetOfLRS_SOL.Singleton, host);
    }
}

