package lrs.test;

import junit.framework.TestCase;

import lrs.*;
import lrs.visitor.*;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_IsSubsetOfLRS extends TestCase {

  IAlgo algo = IsSubsetOfLRS.Singleton;
  
  public void test_empty_lists() {
    LRStruct list1 = makeLRS();
    LRStruct list2 = makeLRS();
    
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    
    list2 = makeLRS(42);
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));
    
    list2 = makeLRS("a", "b");
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));
    
  }
  
  
  public void test_nonEmpty_lists() {
    LRStruct list1 = makeLRS(42);
    LRStruct list2 = makeLRS(42);
    
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));

    list2 = makeLRS(42, 57);
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));

    list2 = makeLRS(23, 42);
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));

    list1 = makeLRS(2, 3);
    list2 = makeLRS(42, 57);
    assertFalse((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));

    list2 = makeLRS(2, 100);
    assertFalse((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));
    
    list2 = makeLRS(2, 100, 3);
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));
    
    list2 = makeLRS(20, 3, 35, 2);
    assertTrue((Boolean) list1.execute(IsSubsetOfLRS.Singleton, list2));
    assertFalse((Boolean) list2.execute(IsSubsetOfLRS.Singleton, list1));
    
  }
  
  
  /**
   * instantiates and fills an LRS with the given values.
   */
  LRStruct makeLRS(Object...args) {
    return LRSFactory.makeFrom(args);
  }
}
