
package Sorter;

/**
 * A general purpose counter class.
 */
public class Counter
{
	/**
	 * The stored count.
	 */
	private int count = 0;
	/**
	 * The amount the count is incremented by every update().
	 */
	private int delta = 0;
	/**
	 * The constructor for the class.
	 * @param delta The amount to increment the counter by every time the counter is updated.
	 */
	public Counter(int delta)
	{
		this.delta = delta;
	}

	/**
	 * Increments the internal count by delta.
	 */
	public void update()
	{
		count += delta;
	}

	/**
	 * Clears the stored count.
	 */
	public void clear()
	{
		count = 0;
	}

	/**
	 * Accessor method for the increment value.
	 * @param delta 
	 */
	public void setDelta(int delta)
	{
		this.delta = delta;
	}

	/**
	 * Accessor method for the stored count.
	 * @return 
	 */
	public int getCount()
	{
		return(count);
	}
}

