
package Sorter;

public class ShakerSorter extends ASorter
{
  
  private static abstract class AState
  {
    public abstract int split(Object[] A, int lo, int hi);
  }
  
  private ShakerSorter.AState forwardState = new AState()
  {
    public int split(Object[] A, int lo, int hi)
    {
      int j = hi;
      while (lo < j)
      {
        if (aOrder.lt(A[j],A[j-1]))
        {
          Object temp = A[j];
          A[j] = A[j-1];
          A[j-1] = temp;
        }
        j--;
      }
      state = reverseState;
      return lo + 1;
    }
  };
  
  private ShakerSorter.AState reverseState = new AState()
  {
    public int split(Object[] A, int lo, int hi)
    {
      int j = lo;
      while (j < hi)
      {
        if (aOrder.lt(A[j+1],A[j]))
        {
          Object temp = A[j];
          A[j] = A[j+1];
          A[j+1] = temp;
        }
        j++;
      }
      state = forwardState;
      return hi;
    }
  };
  
  private ShakerSorter.AState state = forwardState;
  /**
   * @param iCompareOp
   */
  public ShakerSorter(AOrder iCompareOp)
  {
    super(iCompareOp);
  }
  
  /**
   * Splits A[lo:hi] into A[lo:s-1] and A[s:hi] where s is the returned value of this function.
   * @param A the array A[lo:hi] to be sorted.
   * @param lo the low index of A.
   * @param hi the high index of A.
   * @return
   */
  protected int split(Object[] A, int lo, int hi)
  {
    return state.split(A, lo, hi);
  }
  
  /**
   * Joins sorted A[lo:s-1] and sorted A[s:hi] into A[lo:hi].
   * @param A A[lo:s-1] and A[s:hi] are sorted.
   * @param lo the low index of A.
   * @param s
   * @param hi the high index of A.
   */
  protected void join(Object[] A, int lo, int s, int hi)
  {
  }
}

