
package brs;

/**
 * Represents all extrinsic algorithms on a <code>BiTree<code> as a visitor to
 * the BiTree host structure.  The BiTree host will make the appropriate call on
 * this IVisitor's methods.
 * @author Dung X. Nguyen - Copyright 2001 - All rights reserved.
 */
public abstract interface IVisitor {
    /**
    * Called by the host when the host is empty.
    * @param host an empty BiTree on which this IVisitor operates.
    * @param inp the input needed by this IVisitor to perform its task.
    * @return Object the output of this algorithm on the host.
    */
    public abstract Object emptyCase(BiTree host, Object inp);

    /**
    * Called by the host when the host is not empty.
    * @param host a non-empty BiTree on which this IVisitor operates.
    * @param inp the input needed by this IVisitor to perform its task.
    * @return Object the output of this algorithm on the host.
    */
    public abstract Object nonEmptyCase(BiTree host, Object inp);
}

