package brs.visitor;

import brs.*;

public class RotateRight implements IVisitor {
    
    public static final RotateRight Singleton = new RotateRight();
    private RotateRight() {}
    
    public Object emptyCase(BiTree parent, Object nu) {
        return parent;
    }
    public Object nonEmptyCase(final BiTree parent, Object nu) {
        return parent.getLeftSubTree().execute( new IVisitor () { 
            public Object emptyCase(BiTree left, Object nu) {
                return parent;
            }
            
            public Object nonEmptyCase(BiTree left, Object nu) {
                BiTree newRight = new BiTree();
                newRight.insertRoot(parent.getRootDat());
                newRight.setRightSubTree(parent.getRightSubTree());
                newRight.setLeftSubTree(left.getRightSubTree());
                parent.setRootDat(left.getRootDat());
                parent.setLeftSubTree(left.getLeftSubTree());
                parent.setRightSubTree(newRight);
                return parent;
            }
        }, null);
    }
    
}
