package treap;

import brs.visitor.*;
import brs.*;
import java.util.*;

/**
 * Pushes the top element of a treap, if any, down to the bottom and remove it,
 * while maintaining the treap property.
 */
public class PushDown_SOL implements IVisitor {
  private Comparator<TreapTriple> _orderPriority; 
  
  /**
   * Called by the left subtree of the tree that executes PushDown_SOL:
   * @param p the parent of right.
   * @return Boolean true
   */    
  private IVisitor _pushDownHelp1 = new IVisitor() {
    public Object emptyCase (BiTree left, Object parent) {
      ((BiTree)parent).remRoot();
      return Boolean.TRUE;
    }
    
    // may reference _pushDownHelp2:
    public Object nonEmptyCase (BiTree left, Object parent) {
      return ((BiTree)parent).getRightSubTree().execute(_pushDownHelp2, parent);                        
    }
  };           
  /**
   * Called by the right subtree of the tree that executes PushDown_SOL:
   * @param p the parent of right.
   * @return Boolean true
   */
  private IVisitor _pushDownHelp2 = new IVisitor() {
    /**
     * @param p the parent of right.
     * @return Boolean true
     */
    public Object emptyCase (BiTree right, Object p) {
      ((BiTree)p).remRoot();
      return Boolean.TRUE;
    }
    
    public Object nonEmptyCase (BiTree right, Object p) {
      BiTree p2 = (BiTree)p;
      TreapTriple rightRoot = (TreapTriple)right.getRootDat();
      TreapTriple leftRoot = (TreapTriple)p2.getLeftSubTree().getRootDat();
      if (_orderPriority.compare(rightRoot, leftRoot) < 0) {
        p2.execute(RotateLeft.Singleton, null);
        return p2.getLeftSubTree().execute(PushDown_SOL.this, null); 
      }
      else {
        p2.execute(RotateRight.Singleton, null);
        return p2.getRightSubTree().execute(PushDown_SOL.this, null);
      }
    }
  };
  
  
  /**
   * Used when the items in the tree are Comparable objects.
   */
  public PushDown_SOL() {
    _orderPriority = new Comparator<TreapTriple>() {
      public int compare(TreapTriple x, TreapTriple y) {
        return x.getPriorityComparable().compareTo(y);
      }
    };
  }
  
  public PushDown_SOL (Comparator<TreapTriple> orderPriority) {
    _orderPriority = orderPriority;
  }
  
  /**
   */
  public Object emptyCase(BiTree host, Object nu) {
    return Boolean.TRUE;
  }
  
  /**
   */
  public Object nonEmptyCase(BiTree host, Object key) {
    return host.getLeftSubTree().execute(_pushDownHelp1, host);                                                          
  }
}

