package treap;

import brs.visitor.*;
import brs.*;
import java.util.*;

/**
 * Inserts an Object into the host maintaining the host's binary search tree
 * property via a given Comparator.
 * Duplication is not allowed: replaces old data object with the new one.
 * @author Dung X. Nguyen - Copyright 2003 - All rights reserved.
 */
public class TreapDeleter_SOL implements IVisitor {
    private Comparator<TreapTriple> _orderKey;
    private Comparator<TreapTriple> _orderPriority;    
    private IVisitor _pushDown = NoOpVisitor.Singleton;
    
    /**
     * Used when the items in the tree are Comparable objects.
     */
    public TreapDeleter_SOL() {
        _orderKey = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getKeyComparable().compareTo(y);
            }
        };
        _orderPriority = new Comparator<TreapTriple>() {
            public int compare(TreapTriple x, TreapTriple y) {
                return x.getPriorityComparable().compareTo(y);
            }
        };
        _pushDown = new PushDown_SOL();
    }
    
    public TreapDeleter_SOL (Comparator<TreapTriple> orderKey, 
                         Comparator<TreapTriple> orderPriority) {
        _orderKey = orderKey;
        _orderPriority = orderPriority;
        _pushDown = new PushDown_SOL(_orderPriority);
    }
    
    /**
     */
    public Object emptyCase(BiTree host, Object nu) {
        return Boolean.FALSE;
    }
    
    /**
     */
    public Object nonEmptyCase(BiTree host, Object key) {
        TreapTriple k = (TreapTriple) key;        
        TreapTriple root = (TreapTriple) host.getRootDat();

        if (_orderKey.compare(k, root) < 0) {
            return host.getLeftSubTree().execute(this, key); 
        }
        if (_orderKey.compare(k, root) > 0) {
            return host.getRightSubTree().execute(this, key);
        }
        // At this point:  input is equal to root.
        return host.execute(_pushDown, null);
    }
}

