/*
 * Decompiled with CFR 0.152.
 */
package kochModel;

import java.awt.geom.Point2D;
import kochModel.AKochState;
import kochModel.BaseState;
import kochModel.IKochVisitor;
import kochModel.InductState;
import lrs.LRStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Koch {
    private Point2D.Double a;
    private Point2D.Double b;
    private AKochState aKochState = new BaseState();

    public Koch(Point2D.Double a, Point2D.Double b) {
        this.a = a;
        this.b = b;
    }

    public Koch(Point2D.Double a, Point2D.Double b, LRStruct<Koch> kochList) {
        this(a, b);
        this.aKochState = new InductState(kochList);
    }

    public Point2D.Double getA() {
        return this.a;
    }

    public Point2D.Double getB() {
        return this.b;
    }

    void setKochState(AKochState aKochState) {
        this.aKochState = aKochState;
    }

    AKochState getKochState() {
        return this.aKochState;
    }

    public <R, P> R execute(IKochVisitor<R, P> algo, P ... param) {
        return this.aKochState.execute(this, algo, param);
    }

    public LRStruct<Koch> getChildren() {
        return this.aKochState.getChildren(this);
    }

    public void shareState(Koch other) {
        this.a = other.getA();
        this.b = other.getB();
        this.setKochState(other.getKochState());
    }
}

