/*
 * Decompiled with CFR 0.152.
 */
package kochModel;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import kochModel.IFactory;
import kochModel.IKochVisitor;
import kochModel.Koch;
import kochModel.factory.KochCurveFactory;
import kochModel.visitor.CountVisitor;
import kochModel.visitor.GrowVisitor;
import kochModel.visitor.PaintNoParentVisitor;

public class KochModel {
    Point2D.Double ptA = new Point2D.Double(200.0, 500.0);
    Point2D.Double ptB = new Point2D.Double(650.0, 500.0);
    private IFactory aFactory = new KochCurveFactory();
    private Koch koch = this.aFactory.makeBase(this.ptA, this.ptB);
    IKochVisitor<Object, Graphics> paintAlgo = PaintNoParentVisitor.Singleton;

    public void grow() {
        this.koch.execute(GrowVisitor.Singleton, this.aFactory);
    }

    public void paint(Graphics g) {
        this.koch.execute(this.paintAlgo, g);
    }

    public void reset() {
        this.koch = this.aFactory.makeBase(this.ptA, this.ptB);
    }

    public void changeFactoryTo(String s) {
        try {
            Constructor<?> c = Class.forName(s).getConstructors()[0];
            Object[][] args = new Object[][]{new Object[0], {this.aFactory}};
            this.aFactory = (IFactory)c.newInstance(args[c.getParameterTypes().length]);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void changePaintAlgoTo(String s) {
        try {
            this.paintAlgo = (IKochVisitor)Class.forName(s).getDeclaredField("Singleton").get(null);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public int count() {
        return this.koch.execute(CountVisitor.Singleton, new Object[0]);
    }
}

