/*
 * Decompiled with CFR 0.152.
 */
package kochModel.factory;

import java.awt.geom.Point2D;
import kochModel.IFactory;
import kochModel.IKochVisitor;
import kochModel.Koch;
import kochModel.factory.AffineXForm;
import lrs.IAlgo;
import lrs.LRStruct;

public abstract class FractalFactory
implements IFactory {
    private Koch proto;

    public Koch getProto() {
        return this.proto;
    }

    public void setProto(Koch aProto) {
        this.proto = aProto;
    }

    public Koch makeBase(Point2D.Double a, Point2D.Double b) {
        return new Koch(a, b);
    }

    public Koch makeInduct(Point2D.Double a, Point2D.Double b) {
        Point2D.Double delta = new Point2D.Double(b.x - a.x, b.y - a.y);
        Point2D.Double a2 = new Point2D.Double(a.x, a.y);
        final AffineXForm affineXForm = new AffineXForm(a2, delta);
        IKochVisitor<Koch, Object> xfmVisitor = new IKochVisitor<Koch, Object>(){
            IKochVisitor<Koch, Object> thisXfmVisitor = this;

            @Override
            public Koch baseCase(Koch host, Object ... nu) {
                return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()));
            }

            @Override
            public Koch inductCase(Koch host, Object ... nu) {
                LRStruct<Koch> children = host.getChildren().execute(new IAlgo<Koch, LRStruct<Koch>, Object>(){

                    @Override
                    public LRStruct<Koch> emptyCase(LRStruct<? extends Koch> host, Object ... nu) {
                        return new LRStruct<Koch>();
                    }

                    @Override
                    public LRStruct<Koch> nonEmptyCase(LRStruct<? extends Koch> host, Object ... nu) {
                        return host.getRest().execute(this, new Object[0]).insertFront(host.getFirst().execute(thisXfmVisitor, new Object[0]));
                    }
                }, new Object[0]);
                return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()), children);
            }
        };
        return this.proto.execute(xfmVisitor, new Object[0]);
    }
}

