/*
 * Decompiled with CFR 0.152.
 */
package kochModel.factory;

import java.awt.geom.Point2D;
import kochModel.IFactory;
import kochModel.Koch;
import lrs.LRStruct;

public class RectangleSnowflakeFactory
implements IFactory {
    IFactory aFactory;

    public RectangleSnowflakeFactory(IFactory aFactory) {
        this.aFactory = aFactory;
    }

    public Koch makeBase(Point2D.Double a, Point2D.Double b) {
        LRStruct<Koch> kochList = new LRStruct<Koch>();
        double ratio = Math.sqrt(3.0);
        double vx = -((b.y - a.y) / ratio);
        double vy = (b.x - a.x) / ratio;
        Point2D.Double d = new Point2D.Double(a.x + vx, a.y + vy);
        Point2D.Double c = new Point2D.Double(b.x + vx, b.y + vy);
        kochList.insertFront(this.aFactory.makeBase(a, b));
        kochList.insertFront(this.aFactory.makeBase(b, c));
        kochList.insertFront(this.aFactory.makeBase(c, d));
        kochList.insertFront(this.aFactory.makeBase(d, a));
        return new Koch(a, b, kochList);
    }

    public Koch makeInduct(Point2D.Double a, Point2D.Double b) {
        return this.aFactory.makeInduct(a, b);
    }
}

