/*
 * Decompiled with CFR 0.152.
 */
package kochModel.factory;

import java.awt.geom.Point2D;
import kochModel.IFactory;
import kochModel.Koch;
import lrs.LRStruct;

public class SnowflakeFactory
implements IFactory {
    IFactory aFactory;

    public SnowflakeFactory(IFactory aFactory) {
        this.aFactory = aFactory;
    }

    public Koch makeBase(Point2D.Double a, Point2D.Double b) {
        LRStruct<Koch> kochList = new LRStruct<Koch>();
        double vx = b.x - a.x;
        double vy = b.y - a.y;
        Point2D.Double c = new Point2D.Double(a.x + vx / 2.0 - Math.sqrt(3.0) / 2.0 * vy, a.y + vy / 2.0 + Math.sqrt(3.0) / 2.0 * vx);
        kochList.insertFront(this.aFactory.makeBase(a, b));
        kochList.insertFront(this.aFactory.makeBase(b, c));
        kochList.insertFront(this.aFactory.makeBase(c, a));
        return new Koch(a, b, kochList);
    }

    public Koch makeInduct(Point2D.Double a, Point2D.Double b) {
        return this.aFactory.makeInduct(a, b);
    }
}

