/*
 * Decompiled with CFR 0.152.
 */
package kochModel.visitor;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import kochModel.IKochVisitor;
import kochModel.Koch;
import lrs.IAlgo;
import lrs.LRStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaintColorVisitor
implements IKochVisitor<Object, Graphics> {
    public static final PaintColorVisitor Singleton = new PaintColorVisitor();
    private IAlgo<Koch, Object, Graphics> lrsAlgo = new IAlgo<Koch, Object, Graphics>(){

        public Object emptyCase(LRStruct<? extends Koch> host, Graphics ... g) {
            return null;
        }

        public Object nonEmptyCase(LRStruct<? extends Koch> host, Graphics ... g) {
            host.getFirst().execute(PaintColorVisitor.this, g);
            return host.getRest().execute(this, g);
        }
    };
    private Random rand = new Random();
    private int currentRed = 128;
    private int currentGreen = 128;
    private int currentBlue = 128;
    private int delta = 10;

    private PaintColorVisitor() {
    }

    public Object baseCase(Koch host, Graphics ... g) {
        this.paint(host, g[0]);
        return null;
    }

    public Object inductCase(Koch host, Graphics ... g) {
        this.paint(host, g[0]);
        return host.getChildren().execute(this.lrsAlgo, g);
    }

    private Koch paint(Koch host, Graphics g) {
        g.setColor(new Color(this.currentRed, this.currentGreen, this.currentBlue));
        this.currentRed = (256 + this.currentRed + this.rand.nextInt(2 * this.delta) - this.delta) % 256;
        this.currentGreen = (256 + this.currentGreen + this.rand.nextInt(2 * this.delta) - this.delta) % 256;
        this.currentBlue = (256 + this.currentBlue + this.rand.nextInt(2 * this.delta) - this.delta) % 256;
        g.drawLine((int)Math.round(host.getA().x), (int)Math.round(host.getA().y), (int)Math.round(host.getB().x), (int)Math.round(host.getB().y));
        return host;
    }
}

