/*
 * Decompiled with CFR 0.152.
 */
package kochView;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kochView.IControlAdapter;
import kochView.IPaintAdapter;

public class KochFrame
extends JFrame {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton growBtn = new JButton();
    JButton resetBtn = new JButton();
    boolean isApplet = false;
    JComboBox factoriesCBx = new JComboBox();
    JComboBox paintAlgosCBx = new JComboBox();
    IPaintAdapter paintAdapter;
    IControlAdapter controlAdapter;
    JLabel countLbl = new JLabel();

    public KochFrame(IPaintAdapter paintAdapter, IControlAdapter controlAdapter, int closeOp) {
        this.setDefaultCloseOperation(closeOp);
        this.paintAdapter = paintAdapter;
        this.controlAdapter = controlAdapter;
        this.isApplet = this.isApplet;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.factoriesCBx.addItem("kochModel.factory.KochCurveFactory");
        this.factoriesCBx.addItem("kochModel.factory.MyCurveFactory");
        this.factoriesCBx.addItem("kochModel.factory.SnowflakeFactory");
        this.factoriesCBx.addItem("kochModel.factory.RectangleSnowflakeFactory");
        this.factoriesCBx.addItem("kochModel.factory.KochFractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.MyFractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.Tree1FractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.Tree2FractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.Tree1_2FractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.BoxFractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.KochBoxFractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.SnowflakeFractalFactory");
        this.factoriesCBx.addItem("kochModel.factory.RectangleSnowFlakeFractalFactory");
        this.factoriesCBx.setSelectedIndex(0);
        this.paintAlgosCBx.addItem("kochModel.visitor.PaintNoParentVisitor");
        this.paintAlgosCBx.addItem("kochModel.visitor.PaintParentVisitor");
        this.paintAlgosCBx.addItem("kochModel.visitor.PaintColorVisitor");
        this.paintAlgosCBx.setSelectedIndex(0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                KochFrame.this.repaint();
            }
        });
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.setSize(new Dimension(971, 743));
        this.setTitle("Frame Title");
        this.growBtn.setToolTipText("Grow using currently selected factory,");
        this.growBtn.setText("Grow!");
        this.growBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KochFrame.this.growBtn_actionPerformed(e);
            }
        });
        this.resetBtn.setToolTipText("Reset back to base case using currently selected factgory..");
        this.resetBtn.setText("Reset");
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KochFrame.this.resetBtn_actionPerformed(e);
            }
        });
        this.factoriesCBx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KochFrame.this.factoriesCBx_actionPerformed(e);
            }
        });
        this.paintAlgosCBx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KochFrame.this.paintAlgosCBx_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.growBtn, null);
        this.jPanel1.add((Component)this.resetBtn, null);
        this.jPanel1.add((Component)this.factoriesCBx, null);
        this.jPanel1.add((Component)this.countLbl, null);
        this.jPanel1.add((Component)this.factoriesCBx, null);
        this.jPanel1.add((Component)this.paintAlgosCBx, null);
        this.resetBtn_actionPerformed(null);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (!this.isApplet && e.getID() == 201) {
            System.exit(0);
        }
    }

    void growBtn_actionPerformed(ActionEvent e) {
        this.countLbl.setText("# line segs = " + this.controlAdapter.grow());
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.blue);
        this.paintAdapter.paint(g);
    }

    void resetBtn_actionPerformed(ActionEvent e) {
        this.countLbl.setText("# line segs = " + this.controlAdapter.reset());
        this.repaint();
    }

    void factoriesCBx_actionPerformed(ActionEvent e) {
        this.controlAdapter.changeFactoryTo((String)this.factoriesCBx.getItemAt(this.factoriesCBx.getSelectedIndex()));
    }

    void paintAlgosCBx_actionPerformed(ActionEvent e) {
        this.controlAdapter.changePaintAlgoTo((String)this.paintAlgosCBx.getItemAt(this.paintAlgosCBx.getSelectedIndex()));
        this.repaint();
    }
}

