package rac;

import listFW.*;
import listFW.factory.*;


public abstract class AArrayRACFactory implements IRACFactory {
  
  protected static abstract class AArrayContainer implements IRAContainer {
    
    /**
     * A fixed size array that holds the RAC's data
     * The data is assumed to completely fill the array
     * from data[0] up to, but NOT including, data[end].
     */
    protected Object[] data;
    
    /**
     * An index that references the element right AFTER
     * the last element in the RAC's array
     */
    protected int end = 0;

    public AArrayContainer(int maxSize) {
      data = new Object[maxSize];
    }
        
    public void clear() {
      end = 0;
    }
    
    public boolean isFull() {
      return end >= data.length;
    }
    
    
    /**
     * Returns an IList of the elements in the RAC,
     * in the order that they are held in the 
     * the data array.
     */
    public IList elements(IListFactory fact) {
      // STUDENT TO COMPLETE

      return null; // STUB CODE
    }
       
    public Object execute(IRACVisitor v, Object... inp) {
      if(end<=0) return v.emptyCase(this, inp);
      else return v.nonEmptyCase(this, inp);
    }
  }
}