package fp;

/**
 * Defines a lambda that can be folded over a set of objects 
 * of type H, as defined by the IFoldHost interface.
 * R is the type of the return value and also the 
 * type of base, the recursive result that is handed to the 
 * lambda.
 * P is the type of the arbitrary input parameter.
 */
public interface IFoldAlgo<H, R, P> {
  /**
   * apply is called on every element of the set when the 
   * lambda is folded over the set.
   * @param host The given element of the set, of type H.
   * @param base The previous recursive result, of type R.
   * @param inp A vararg list of arbitrary input parameters
   * @return The new recursive result, of type R.
   */
  public abstract R apply( H host, R base, P... inp); 
}