package kochModel;
import java.awt.*;
import lrs.*;
import fp.*;



/**
 * This is the base case state for the Koch curve.   This state is graphically represented as a straight line.
 */
class BaseState extends AKochState {
  
  public <R,P> R execute(Koch host, IKochVisitor<R,P> algo, P...param) {
    return algo.baseCase(host, param);
  }

  public LRStruct<Koch> getChildren(Koch host) {
    throw new IllegalStateException("Koch base state has no children!");
  }  
}

