package kochModel;
//import LRStructure.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;
/**
 * This abstract factory  class fully encapsulates and abstracts the behavior of constructing Koch curves.
 * It is a recursive capable factory because it provides a
 * method to  create the first Koch curve (base case) and a method to "grow" the curve (inductive case)
 */
public interface IFactory {


 /**
  * Creates a single Koch curve.  Used to generate the initial Koch curve.    It is not specified at this abstraction level exactly what sort of curve is made.
  * @param a The first endpoint of the straight line.
  * @param b The second endpoint of the straight line.
  * @return A Koch curve.
  */
 public abstract Koch makeBase(Double a, Double b);

 /**
  * Performs the inductive step of recursively growing the curve.   Whatever is done is done in the context of an existing Koch curve.
  * At this abstraction level it does not matter what this step does as the context will remain a Koch curve.
  *
  * @param context The Koch object context in which the growing is taking place.
  */
 public abstract Koch makeInduct(Double a, Double b);

}

