package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.*;

public abstract class FractalFactory implements IFactory {
  
  private Koch proto;
  
  public Koch getProto() {
    return proto;
  }
  
  public void  setProto(Koch aProto) {
    proto = aProto;
  }
  
  public Koch makeBase(Point2D.Double a, Point2D.Double b) {
    return new Koch(a, b);
  }
  
  public Koch makeInduct(Point2D.Double a, Point2D.Double b) {
    Point2D.Double delta = new Point2D.Double((double)(b.x-a.x), (double)(b.y-a.y));
    Point2D.Double a2 = new Point2D.Double((double) a.x, (double) a.y);
    final AffineXForm affineXForm = new AffineXForm(a2, delta);
    
    IKochVisitor<Koch, Object> xfmVisitor = new IKochVisitor<Koch, Object>() {
      IKochVisitor<Koch, Object> thisXfmVisitor = this;
      public Koch baseCase(Koch host, Object... nu) {
        return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()));
      }
      
      public Koch inductCase(Koch host, Object... nu) {
        LRStruct<Koch> children = host.getChildren().execute(new IAlgo<Koch, LRStruct<Koch>, Object> () {
          public LRStruct<Koch> emptyCase(LRStruct<? extends Koch> host, Object... nu) {
            return new LRStruct<Koch>();
          }
          public LRStruct<Koch> nonEmptyCase(LRStruct<? extends Koch> host, Object... nu) {
            return host.getRest().execute(this).insertFront(host.getFirst().execute(thisXfmVisitor));
          }   
        });        
        return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()), 
                        children);
      }      
    };
    
    return proto.execute(xfmVisitor);  
  }
  
}
