package kochModel.factory;

import kochModel.*;
import kochModel.visitor.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class KochBoxFractalFactory extends FractalFactory {
  
  public KochBoxFractalFactory() {
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(1.0,0.0);
    Koch proto = new Koch(p0, p1);
    
    proto.execute(GrowVisitor.Singleton, new BoxFractalFactory());
    proto.execute(GrowVisitor.Singleton, new KochFractalFactory());
    
    setProto(proto);
  }
}
