package kochModel.factory;


import java.awt.geom.Point2D;
import lrs.*;

/**
 * The factory to create a custom Koch curve
 */
public class MyCurveFactory extends CurveFactory
{
  
  /**
   * Defines the prototype points needed (without endpoints) for a custom curve.
   */
  public MyCurveFactory() {
    double height = 1.0/3.0*Math.sqrt(3.0)/2.0;
    getProtoList().insertFront(new Point2D.Double(5.0/6.0,-height));
    getProtoList().insertFront(new Point2D.Double(0.5, height));
    getProtoList().insertFront(new Point2D.Double(1.0/6.0,-height));
  }
}