package kochModel.factory;

import kochModel.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class MyFractalFactory extends FractalFactory {
  
  public MyFractalFactory() {
    double height = 1.0/3.0*Math.sqrt(3.0)/2.0;
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(1.0/6.0,-height);
    Double p2 = new Double(0.5,height);
    Double p3 = new Double(5.0/6.0,-height);
    Double p4 = new Double(1.0, 0.0);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(new Koch(p3, p4));
    children.insertFront(new Koch(p2, p3));
    children.insertFront(new Koch(p1, p2));
    children.insertFront(new Koch(p0, p1));
    
    setProto(new Koch(p0, p4, children));
  }
}
