package kochModel.factory;


import lrs.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;

import kochModel.*;
import kochModel.visitor.*;

/**
 * A special factory that will create initally creates a non-base case Koch curve consisting of  Koch curves constructed by the stored factory
 * in a triangle.   After that, the factory used to grow the curve is the same as stored factory.
 */
public class RectangleSnowFlakeFractalFactory extends FractalFactory
{
  
  IFactory aFactory;
  /**
   * The constructor simply saves the supplied factory for later use.
   */
  public RectangleSnowFlakeFractalFactory(IFactory aFactory)
  {
    this.aFactory = aFactory;
    double ratio = 1.0/Math.sqrt(3.0);
    Double p0 = new Double(0.0, 0.0);
    Double p1 = new Double(1.0, 0.0);
    Double p2 = new Double(1.0, ratio);
    Double p3 = new Double(0.0, ratio);
    
    LRStruct<Koch> children = new LRStruct<Koch>();
    children.insertFront(aFactory.makeBase(p0, p1));
    children.insertFront(aFactory.makeBase(p1, p2));
    children.insertFront(aFactory.makeBase(p2, p3));
    children.insertFront(aFactory.makeBase(p3, p0));
    setProto(new Koch(p0, p1, children));

  }
  
  /**
   * Creates a Koch curve consisting of a triangle of Koch curves generated by the stored factory's makeBase() method.
   * @param a The starting point for the base of the triangle.
   * @param b The ending point for the base of the triangle.
   * @return A Koch curve.
   */
  public Koch makeBase(Double a, Double b)
  {
    return super.makeInduct(a, b);
  }
  
  
  /**
   * Constructs the list of Koch curves from the prototype list  and changes the state of the context Koch object by delegating the call to the stored factory.
   * @param context The Koch object context in which the growing is taking place.
   */
  public Koch makeInduct(Double a, Double b) {
    return aFactory.makeInduct(a,b);
  }
}