package kochModel.factory;


import lrs.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;

import kochModel.*;

/**
 * A special factory that will create initally creates a non-base case Koch curve consisting of  Koch curves constructed by the stored factory
 * in a rectangle.   After that, the factory used to grow the curve is the same as stored factory.
 */

public class RectangleSnowflakeFactory implements IFactory
{

  IFactory aFactory;
  /**
  * The constructor simply saves the supplied factory for later use.
  */
 public RectangleSnowflakeFactory(IFactory aFactory)
   {
       this.aFactory = aFactory;
   }

 /**
  * Creates a Koch curve consisting of a rectangle of Koch curves generated by the stored factory's makeBase() method.
  * @param a The starting point for the base of the rectangle.
  * @param b The ending point for the base of the rectangle.
  * @return A Koch curve.
  */
 public Koch makeBase(Double a, Double b)
 {
  LRStruct<Koch> kochList = new LRStruct<Koch>();

//  double ratio =  0.5+Math.sqrt(5.0)/2.0 ;  //golden ratio
//  double ratio =  2.0/Math.sqrt(3.0); // matches height of triangle
    double ratio = Math.sqrt(3.0);
  double vx = -((b.y - a.y) /ratio);
  double vy = ((b.x - a.x)/ratio);
  Double d = new Double( a.x + vx, a.y+vy);
  Double c = new Double( b.x +vx, b.y+vy);

  kochList.insertFront(aFactory.makeBase(a,b));
  kochList.insertFront(aFactory.makeBase(b,c));
  kochList.insertFront(aFactory.makeBase(c,d));
  kochList.insertFront(aFactory.makeBase(d,a));

  return new Koch(a, b, kochList);
 }


 /**
  * Constructs the list of Koch curves from the prototype list  and changes the state of the context Koch object by delegating the call to the stored factory.
  * @param context The Koch object context in which the growing is taking place.
  */
 public Koch makeInduct(Double a, Double b)
 {
  return aFactory.makeInduct(a,b);
//    return makeBase(a,b);
 }
}