package kochModel.factory;

import kochModel.*;
import kochModel.visitor.*;
import lrs.*;
import java.awt.geom.Point2D.Double;

public class Tree1_2FractalFactory extends FractalFactory {
  
  public Tree1_2FractalFactory() {
    Double p0 = new Double(0.0,0.0);
    Double p1 = new Double(1.0,0.0);
    Koch proto = new Koch(p0, p1);
    
    proto.execute(GrowVisitor.Singleton, new Tree1FractalFactory());
    proto.execute(GrowVisitor.Singleton, new Tree2FractalFactory());
    
    setProto(proto);
  }
}
