package kochModel.visitor;

import lrs.*;
import kochModel.*;

public class CountVisitor implements IKochVisitor<Integer, Object> {
  
  public static final CountVisitor Singleton = new CountVisitor();
  
  private CountVisitor() {}
  
  private IAlgo<Koch, Integer, Object> lrsAlgo = new IAlgo<Koch, Integer, Object>() {
    public Integer emptyCase(LRStruct<? extends Koch> host, Object... inp) {
      return 0;
    }
    public Integer nonEmptyCase(LRStruct<? extends Koch> host, Object... inp) {
      return host.getFirst().execute(CountVisitor.this) + host.getRest().execute(this);
    }   
  };

  public Integer baseCase(Koch host, Object... param) {
    return 1;
  }
  
  public Integer inductCase(Koch host, Object... param) {
    return host.getChildren().execute(lrsAlgo);
  }
}