package kochModel.visitor;

import lrs.*;
import kochModel.*;

public class GrowVisitor implements IKochVisitor<Object, IFactory> {
  
  public static final GrowVisitor Singleton = new GrowVisitor();
  
  private GrowVisitor() {}

  private IAlgo<Koch, Object, IFactory> lrsAlgo = new IAlgo<Koch, Object, IFactory>() {
    public Object emptyCase(LRStruct<? extends Koch> host, IFactory... fac) {
      return null;
    }
    public Object nonEmptyCase(LRStruct<? extends Koch> host, IFactory... fac) {
      host.getFirst().execute(GrowVisitor.this, fac); 
      return host.getRest().execute(this,fac);
    }   
  };
  
  public Object baseCase(Koch host, IFactory... fac) {
    host.shareState(fac[0].makeInduct(host.getA(),host.getB()));
    return null;
  }
  
  public Object inductCase(Koch host, IFactory... fac) {
    return host.getChildren().execute(lrsAlgo, fac[0]);
  }
  
}