package kochModel.visitor;

import lrs.*;
import kochModel.*;
import java.awt.Graphics;

public class PaintNoParentVisitor implements IKochVisitor<Object,Graphics> {

  public static final PaintNoParentVisitor Singleton = new PaintNoParentVisitor();
  
  private PaintNoParentVisitor() {}

  private IAlgo<Koch, Object, Graphics> lrsAlgo = new IAlgo<Koch, Object, Graphics>() {
    public Object emptyCase(LRStruct<? extends Koch> host, Graphics... g) {
      return null;
    }
    public Object nonEmptyCase(LRStruct<? extends Koch> host, Graphics... g) {
      host.getFirst().execute(PaintNoParentVisitor.this, g); 
      return host.getRest().execute(this,g);
    }   
  };
  
  public Object baseCase(Koch host, Graphics... g) {
    g[0].drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
                              (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    return host.getChildren().execute(lrsAlgo, g);
  }  
}