package kochModel.visitor;

import lrs.*;
import kochModel.*;
import java.awt.Graphics;

public class PaintParentVisitor implements IKochVisitor<Object, Graphics> {
  
  public static final PaintParentVisitor Singleton = new PaintParentVisitor();
  
  private PaintParentVisitor() {}
  
  private IAlgo<Koch, Object, Graphics> lrsAlgo = new IAlgo<Koch, Object, Graphics>() {
    public Object emptyCase(LRStruct<? extends Koch> host, Graphics... g) {
      return null;
    }
    public Object nonEmptyCase(LRStruct<? extends Koch> host, Graphics... g) {
      host.getFirst().execute(PaintParentVisitor.this, g); 
      return host.getRest().execute(this,g);
    }   
  };
  
  public Object baseCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    return host.getChildren().execute(lrsAlgo, g);
  }
    
  private void paint(Koch host, Graphics g) {
    g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
               (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    
  }
}