package lrs;

/**
 * Represents the empty state of a mutable list LRStruct. Uses the
 * Singleton pattern.
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @since 8/25/05
 */
class EmptyNode<E> extends ANode<E> {
    /**
     * Singleton Pattern.
     */
    final static EmptyNode Singleton = new EmptyNode();
    private EmptyNode() {}

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<E> getRest(LRStruct<E> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    E getFirst(LRStruct<E> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<E> setRest(LRStruct<E> tail, LRStruct<E> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no tail.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<E> setFirst(E dat, LRStruct<E> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * The owner becomes non-empty and has dat as its first element.
     */
    LRStruct<E> insertFront(E dat, LRStruct<E> owner) {
        return owner.setHead(new NENode(dat, new LRStruct<E>(this)));
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    E removeFront(LRStruct<E> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no front.");
    }

    /**
    * Calls the <code>IAlgo</code> visitor's empty case.
    */
    <R,P> R execute(LRStruct<E> owner, IAlgo<? super E, R, P> algo, P... inp)  {
        return algo.emptyCase(owner, inp);
    }
}

